@php
    use Carbon\Carbon;
@endphp

@extends('layouts.pdf.index')

{{-- @section('content-download') --}}
<div class="noprint print-download-buttons">
    @include('layouts.pdf.back-button')
    @include('layouts.pdf.print-button')
    <button type="button" class="btn-hide-header" style="padding: 10px" onclick="hideIdCardBackSide()">
        {{ __('Show Front Side') }}
    </button>
    <button type="button" class="btn-hide-header" style="padding: 10px" onclick="showIdCardBackSide()">
        {{ __('Show Back Side') }}
    </button>
</div>
<div style="clear: both;"></div>
{{-- @endsection --}}

@section('content')
    <style>
        .fw700 {
            font-weight: 700
        }

        * {
            padding: 0%;
            margin: 0%
        }

        .text-center {
            text-align: center
        }

        .d-flex1 {
            display: flex;
            justify-content: flex-start;
            flex-wrap: wrap;
            gap: 60px;


        }

        .form-view {
            /* height: 100%; */
            width: 750px;
        }

        .id-card-back-footer li {
            text-align: center
        }
    </style>
    <div class="">
        @foreach ($teachers as $key => $teacher)
            <div style="float:left;overflow: hidden; margin: 15px 20px 35px 20px; height: 300px; width: 200px; background: #7ed9ff;border-radius:7px;box-sizing: border-box; "
                class="show-id-card-front-side teacher_card_container">
                <div
                    style="display:flex; flex-direction:column; justify-content:space-between; height: 100%;box-sizing: border-box;">
                    <div id="id_card">
                        <div class="top__bg"
                            style="
                            background-color: #71C9ED;
                            border-bottom-right-radius: 100%;

                        ">
                            <div class="" style="padding: 7.5px 5px;">
                                <table style="width: 100%;">
                                    <tr>
                                        <td style="width: 20%;">
                                            <img src="{{ get_logo() }}" alt=""
                                                style="height: 100%; width: 100%;">
                                        </td>
                                        <td style="width: 80%;">
                                            <p class="fw700 text-center" style="font-size:16px; ">
                                                {{ get_option('school_name') }}
                                            </p>
                                        </td>
                                    </tr>
                                </table>
                            </div>
                            <div class="mt-1">
                                <p class="text-center fw700"
                                    style="background: #333333;color:#fff; padding: 5px; font-size: 17px;">
                                    {{ _lang('Teacher ID Card') }}
                                </p>
                            </div>
                            <div class="image" style="text-align: center; margin-top: 10px;">
                                <img src="{{ asset('storage/users/' . $teacher->user->image) }}" alt=""
                                    style="
                                        height: 68px;
                                        min-height: 68px;
                                        width: 68px;
                                        min-width: 68px;
                                        object-fit: cover;
                                        border-radius: 50%;
                                        border: 2px solid #333333;
                                        overflow: hidden;
                                    ">
                            </div>
                        </div>
                        <div class="text-center" style="margin-top: 5px;padding: 0 5px;">
                            <p class="fw700" style="height: 26px;">
                                <span style="text-transform: uppercase;font-size: 12px;">
                                    {{ $teacher->name }}
                                </span>
                            </p>

                            <p class="fw700">
                                <span class="lbl" style="font-size: 12px;">{{ _lang('Des') }} :</span>
                                <span style="word-break: break-word; font-size: 12px;">{{ $teacher->designation }}</span>
                            </p>
                        </div>
                    </div>
                    <div class="d-flex"
                        style="
                    margin-top: 10px;
                    align-items: end;
                    ">
                        <div
                            style="
                        padding-left: 10px;
                        padding-bottom: 10px;
                        ">
                            <span
                                style="background: #fff;
                            padding: 5px;
                            display: inline-block;
                            max-width: 90px;">
                                @php
                                    // Generate the barcode for each teacher
                                    $text = $teacher->name; // You can use a unique identifier for the teacher here
                                    $barcode = new Picqer\Barcode\BarcodeGeneratorPNG();
                                    $barcodeImage = $barcode->getBarcode($text, $barcode::TYPE_CODE_128);
                                @endphp
                                <img src="data:image/png;base64,{{ base64_encode($barcodeImage) }}" alt=""
                                    style="height: 15px; width: 100%; display: block; margin: 0 auto;">
                                <!-- Display text under the barcode -->
                                <p class="teacher_name_qr"
                                    style="text-align: center;display: block;text-transform: uppercase; font-size:9px;padding:0; margin-top: 3px; word-break: break-word;">
                                    {{ $text }}</p>
                            </span>
                        </div>
                        <div
                            style="
                        padding-right: 10px;
                        padding-bottom: 10px;
                        background-color: #71C9ED;
                        border-top-left-radius: 100%;
                        min-width: 75px;
                        text-align: right;
                        display: flex;
                        justify-content: end;
                        box-sizing: border-box;
                        ">
                            <span>
                                @if ($principalSignature)
                                    <img src="{{ asset('storage/signatures/' . $principalSignature->image) }}"
                                        alt="" style="height: 20px;object-fit: contain;width:60px">
                                @endif
                                <p style="text-align: center; font-size:12px;padding:0%">
                                    Principal
                                </p>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
            <div style="
                float: left;
                box-sizing: border-box;
                border-radius: 7px;
                margin: 15px 20px 35px 20px;
                height: 300px;
                width: 200px;
                background: rgb(245, 243, 243);
                background: #71c9ed94;
                display: none;
            "
                class="show-id-card-back-side teacher_card_back_container">
                <div
                    style="
                    padding: 7.5px;
                    display: flex;
                    flex-direction: column;
                    justify-content: space-between;
                    box-sizing: border-box;
                    height: 100%;
                    ">
                    <div>
                        <div class="text-center">
                            <img src="{{ get_logo() }}" alt="" style="height: 52px; object-fit: contain"
                                class="text-center" />
                        </div>
                        <div style="margin-top: 10px; font-size: 12px; line-height: 15px">
                            <li>
                                <span style="min-width: 85px; display: inline-block">Guidance</span>
                                <span>: {{ $settings['guidance'] }}</span>
                            </li>

                            <li>
                                <span style="min-width: 85px; display: inline-block">Academic Office</span>
                                <span>: {{ $settings['academic_office'] }}</span>
                            </li>
                            <li>
                                <span style="min-width: 85px; display: inline-block">Tuition Fee</span>
                                <span>: {{ $settings['tuition_fee'] }}</span>
                            </li>
                            <li>
                                <span style="min-width: 85px; display: inline-block">Exam Office</span>
                                <span>: {{ $settings['exam_office'] }}</span>
                            </li>
                        </div>
                        <p
                            style="
                        margin-top: 10px;
                        font-weight: 500;
                        font-size: 15px;
                        line-height: 16px;
                        ">
                            Anyone finding this lost <br> Identity Card is requested to <br> return to the
                            principal.
                        </p>
                    </div>
                    <div style="font-size: 12px; line-height: 14px" class="text-center id-card-back-footer">
                        <li class="fw700">{{ get_option('school_name') }}</li>
                        <li>{{ $settings['address'] }}</li>
                        <li>Phone: {{ $settings['phone'] }}</li>
                        <li class="fw700">
                            Web: <a href="{{ $settings['website_link'] }}">{{ $settings['website_link'] }}</a>
                        </li>
                    </div>
                </div>
            </div>


            @if ($key != 0 && ($key + 1) % 9 == 0)
                <div class="clearfix"></div>
                <div class="page2el" style="margin: 10px;">
                </div>
            @endif
        @endforeach
    </div>


    <div style="clear: both;"></div>
@endsection
@section('scripts')
    <script>
        function showIdCardBackSide() {
            console.log('1 :>> ');
            var backSideElements = document.getElementsByClassName("show-id-card-back-side");
            var frontSideElements = document.getElementsByClassName("show-id-card-front-side");

            // Loop through the collection of elements with the specified class and set their display style
            for (var i = 0; i < backSideElements.length; i++) {
                backSideElements[i].style.display = "block";
            }

            for (var j = 0; j < frontSideElements.length; j++) {
                frontSideElements[j].style.display = "none";
            }
        }

        function hideIdCardBackSide() {
            console.log('3 :>> ');
            var backSideElements = document.getElementsByClassName("show-id-card-back-side");
            var frontSideElements = document.getElementsByClassName("show-id-card-front-side");

            // Loop through the collection of elements with the specified class and set their display style
            for (var i = 0; i < backSideElements.length; i++) {
                backSideElements[i].style.display = "none";
            }

            for (var j = 0; j < frontSideElements.length; j++) {
                frontSideElements[j].style.display = "block";
            }
        }
    </script>
@endsection
