<?php

namespace Modules\Quiz\Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Modules\Quiz\Models\Topic;

class TopicFactory extends Factory
{
    protected $model = Topic::class;

    public function definition(): array
    {
        return [
            'institute_id' => 1,
            'branch_id' => 1,
            'title' => $this->faker->sentence(3), // Generate a title with 3 words
            'description' => $this->faker->paragraph, // Generate a random description
            'per_q_mark' => $this->faker->numberBetween(1, 10), // Random marks per question
            'timer' => $this->faker->optional()->numberBetween(10, 60), // Optional timer between 10 and 60 minutes
            'show_ans' => $this->faker->boolean, // Random boolean for showing answers
            'amount' => $this->faker->optional()->randomFloat(2, 5, 20), // Optional amount between 5.00 and 20.00
            'created_at' => now(),
            'updated_at' => now(),
        ];
    }
}
