<?php

namespace Modules\Examination\Database\Seeders;

use Carbon\Carbon;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class ClassExamTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $classes = DB::table('classes')->get();   // adjust table name if different
        $exams   = DB::table('exams')->take(3)->get(); // ✅ only first 3 exams

        $data = [];
        foreach ($classes as $class) {
            foreach ($exams as $exam) {
                $data[] = [
                    'institute_id' => $exam->institute_id,
                    'branch_id' => $exam->branch_id,
                    'class_id' => $class->id,
                    'exam_id' => $exam->id,
                    'merit_process_type_id' => 1,
                    'created_at' => Carbon::now(),
                    'updated_at' => Carbon::now(),
                ];
            }
        }

        // insert in chunks (avoid memory issues if big dataset)
        foreach (array_chunk($data, 500) as $chunk) {
            DB::table('class_exams')->insert($chunk);
        }
    }
}
